<?php

session_start(); 
if(!isset($_SESSION['setadmin']) || $_SESSION['setadmin'] != 1){
	header("Location: /login.php");
}

$no_of_urls = 45000;

include_once('admincp.config.php');

// define a head head for xml files.
$head = '<?xml version=\'1.0\' encoding=\'UTF-8\'?>';
$head .= "\n";

// define head for urls stiemap
$head_url = '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
$head_url .= "\n";

// define head for urls stiemap
$head_map = '<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
$head_map .= "\n";

// closing out stuff for sitemap
$footer_url = '</urlset>';
$footer_url .= "\n";

// closing out stuff for sitemap index
$footer_map = '</sitemapindex>';
$footer_map .= "\n";

// Add domain root as the first item in sitemap
$content =  
'<url>
	<loc>'.$config["site_url"].'</loc>
    <lastmod>' . date("Y-m-d") . '</lastmod>
	<changefreq>weekly</changefreq>
	<priority>1.0</priority>
</url>';
$content .= "\n";

// Get data for pages
$sql = $conn->query("SELECT page_slug, date_updated FROM content");
$data = $sql->fetchall();

// insert pages into content variable
foreach ($data as $row) :
	
$content .=
'<url>
    <loc>'.$config["site_url"].'/page/' . $row["page_slug"] . '/</loc>
    <lastmod>' . date("Y-m-d", strtotime($row["date_updated"])) . '</lastmod>
    <changefreq>weekly</changefreq>
    <priority>0.5</priority>
</url>';
$content .= "\n";

endforeach;

// Combing all parts
$sitemap_data = $head . $head_url . $content . $footer_url;

// Create the first sitemap with main domain and pages.
file_put_contents(dirname(__FILE__).'/../sitemap/sitemap.xml', $sitemap_data);




$sql = $conn->query("SELECT domain, updated FROM sites");
$data = $sql->fetchall();

$file_no = 0;
$counter = 0;
$content = '';

$total = count($data);


foreach ($data as $row) 
{
    // $check = $counter * ($file_no + 1)
    // if($counter < 10 && $counter != $total - 1)
    // {
        $content .=
'<url>
    <loc>'.$config["site_url"].'/'.$row['domain'].'</loc>
    <lastmod>'. date("Y-m-d", strtotime($row['updated'])) .'</lastmod>
    <changefreq>weekly</changefreq>
    <priority>0.5</priority>
</url>';
        $content .= "\n";
        
        // increment the sites counter
        $counter++;

        $check = $counter +( $no_of_urls * $file_no );

        $make = ( $counter == $no_of_urls || $check == $total ) ? true : false;
    // }
    
    if( $make )
    {
    	// Combine all data
    	$sitemap_data = $head . $head_url . $content . $footer_url;

    	// Dump the data into a new numbered sitemap
    	file_put_contents(dirname(__FILE__).'/../sitemap/sitemap_' . $file_no . '.xml', $sitemap_data);

    	$file_no++;
    	$counter = 0;
    	$content = "";
    }
}
                
$first_map = 
'<sitemap>
	<loc>' . $config["site_url"] . '/sitemap/sitemap.xml</loc>
	<lastmod>' . date('Y-m-d') . '</lastmod>
</sitemap>';
$first_map .= "\n";

$next_map = '';

$i = 0;

while($i <= $file_no)
{

$next_map .= 
'<sitemap>
	<loc>' . $config["site_url"] . '/sitemap/sitemap_' . $i . '.xml</loc>
	<lastmod>' . date('Y-m-d') . '</lastmod>
</sitemap>';
$next_map .= "\n";

$i++;

}

$sitemap_data = $head . $head_map . $first_map . $next_map . $footer_map;

file_put_contents(dirname(__FILE__).'/../sitemap.xml', $sitemap_data);

header("Location: index.php?s=sitemap");
